/*!\file:  OutputResultsx.h
 * \brief header file for outputing results
 */ 

#ifndef _OUTPUTRESULTSX_H
#define _OUTPUTRESULTSX_H

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../DataSet/DataSet.h"

#ifdef _SERIAL_
#include <mex.h>
void OutputResultsx(mxArray** pdataref, Elements* elements, Nodes* nodes, Vertices* vertices, Loads* loads,  Materials* materials, Parameters* parameters,DataSet* results);
void MatlabWriteResults(mxArray** pdataref, Parameters* parameters, DataSet* results);
#else
void OutputResultsx(Elements* elements, Nodes* nodes, Vertices* vertices, Loads* loads,  Materials* materials, Parameters* parameters,DataSet* results);
void FileWriteResults(Parameters* parameters, DataSet* results);
#endif

/* local prototypes: */
void ElementResultsToPatch(Elements* elements,  Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,DataSet* results);

#endif  /* _OUTPUTRESULTS_H */

