/*!\file GetSolutionFromInputsx
 * \brief: update datasets using  parameter inputs
 */

#include "./GetSolutionFromInputsx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void	GetSolutionFromInputsx( Vec* psolution, Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads, Materials* materials,  Parameters* parameters){

	/*intermediary: */
	int gsize;
	int i;
	Element* element=NULL;

	int analysis_type;

	/*output: */
	Vec solution=NULL;

	/*retrive parameters: */
	parameters->FindParam(&analysis_type,AnalysisTypeEnum);

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Get size of vector: */
	gsize=nodes->NumberOfDofs(analysis_type);
	
	/*Initialize solution: */
	solution=NewVec(gsize);
	
	/*Go through elements and plug solution: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->GetSolutionFromInputs(solution);
	}

	/*Assemble vector: */
	VecAssemblyBegin(solution);
	VecAssemblyEnd(solution);

	/*Assign output pointers:*/
	*psolution=solution;

}
