/*!\file ComputeBasalStressx
 * \brief: compute pressure according to each element
 */

#include "./ComputeBasalStressx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void	ComputeBasalStressx( Vec* psigma,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads, Materials* materials,Parameters* parameters){

	/*Intermediary*/
	int i;
	int      found=0;
	double   numberofelements;
	Element* element=NULL;

	/*output: */
	Vec sigma=NULL;

	/*Recover numberofelements: */
	found= parameters->FindParam(&numberofelements,NumberOfElementsEnum);
	if (!found) ISSMERROR("numberofelements not provided in parameters");

	/*Allocate sigma on numberofelements: */
	sigma=NewVec((int)numberofelements);

	/*Get elements configured: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Compute basal stress for each element: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->ComputeBasalStress(sigma);
	}

	/*Assemble vector: */
	VecAssemblyBegin(sigma);
	VecAssemblyEnd(sigma);

	/*Assign output pointers: */
	*psigma=sigma;
	
}
