/* \file ModelProcessorx.h
 * \brief  Header file for model processor
 */

#ifndef _MODEL_PROCESSORX_H_
#define _MODEL_PROCESSORX_H_

#define RIFTINFOSIZE 11

class DataSet;
class IoModel;
class Parameters;
#include "../../io/io.h"

void ModelProcessorx(Elements** pelements, Nodes** pnodes, Vertices** pvertices, DataSet** pmaterials, Constraints** pconstraints, Loads** ploads, Parameters** pparameters, ConstDataHandle iomodel_handle,int solution_type,int nummodels, int* analysis_type_list);

/*Creation of fem datasets: general drivers*/
void  CreateDataSets(Elements** pelements,Nodes** pnodes,Vertices** pvertices, DataSet** pmaterials, Constraints** pconstraints, Loads** ploads,Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int solution_type,int analysis_type,int nummodels,int analysis_counter);
void  CreateElementsVerticesAndMaterials(Elements** pelements,Vertices** pvertices,DataSet** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle,int nummodels);
void  CreateParameters(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int solution_type,int analysis_type,int analysis_counter);
void  CreateParametersControl(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int analysis_type);
void  CreateParametersQmu(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int analysis_type);

/*Creation of fem datasets: specialised drivers: */

/*diagnostic horizontal*/
void	CreateNodesDiagnosticHoriz(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticHoriz(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsDiagnosticHoriz(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticHoriz(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic vertical*/
void	CreateNodesDiagnosticVert(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticVert(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsDiagnosticVert(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticVert(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic hutter*/
void	CreateNodesDiagnosticHutter(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticHutter(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsDiagnosticHutter(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticHutter(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic stokes*/
void	CreateNodesDiagnosticStokes(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticStokes(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsDiagnosticStokes(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticStokes(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*slope compute*/
void	CreateNodesSlopeCompute(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsSlopeCompute(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsSlopeCompute(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsSlopeCompute(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*thermal:*/
void	CreateNodesThermal(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsThermal(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsThermal(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsThermal(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*melting:*/
void	CreateNodesMelting(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsMelting(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsMelting(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsMelting(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*prognostic:*/
void	CreateNodesPrognostic(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsPrognostic(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsPrognostic(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsPrognostic(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*prognostic2:*/
void	CreateNodesPrognostic2(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsPrognostic2(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsPrognostic2(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsPrognostic2(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*balancedthickness:*/
void	CreateNodesBalancedthickness(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedthickness(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsBalancedthickness(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsBalancedthickness(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

void	CreateNodesBalancedthickness2(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedthickness2(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsBalancedthickness2(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsBalancedthickness2(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*balancedvelocities:*/
void	CreateNodesBalancedvelocities(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedvelocities(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsBalancedvelocities(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsBalancedvelocities(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*partitioning: */
void  ElementsAndVerticesPartitioning(bool** pmy_elements, bool** pmy_vertices, bool** pmy_bordervertices, IoModel* iomodel, ConstDataHandle iomodel_handle);
void  NodesPartitioning(bool** pmy_nodes,bool* my_elements, bool* my_vertices, bool* my_bordervertices, IoModel* iomodel, ConstDataHandle iomodel_handle,bool continuous);

/*Connectivity*/
void  CreateSingleNodeToElementConnectivity(IoModel* iomodel);
void  CreateNumberNodeToElementConnectivity(IoModel* iomodel);

/*Diverse: */
void  SortDataSets(Elements** pelements,Nodes** pnodes,Vertices** pvertices, Loads** ploads, DataSet** pmaterials, Constraints** pconstraints, Parameters** pparameters);
void  UpdateCounters(IoModel* iomodel,Nodes** pnodes,Loads** ploads, Constraints** pconstraints);

#endif
