/*!\file ModelProcessorx
 * \brief: create datasets using input binary file and a set of requested analyses
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../include/include.h"
#include "../../modules/modules.h"

void ModelProcessorx(Elements** pelements, Nodes** pnodes, Vertices** pvertices, DataSet** pmaterials, Constraints** pconstraints, Loads** ploads, Parameters** pparameters, ConstDataHandle IOMODEL,int solution_type,int nummodels, int* analysis_type_list){

	int i;
	int analysis_type;
	
	/*output: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	DataSet* materials=NULL;
	Constraints* constraints=NULL;
	Loads* loads=NULL;
	Parameters* parameters=NULL;


	/*intermediary: */
	IoModel* iomodel=NULL;

	_printf_("   fill model with matlab workspace data\n");
	iomodel = new IoModel(IOMODEL);

	for(i=0;i<nummodels;i++){

		analysis_type=analysis_type_list[i];
	
		_printf_("   create datasets for analysis %s\n",EnumAsString(analysis_type));
		CreateDataSets(&elements,&nodes,&vertices,&materials,&constraints,&loads,&parameters,iomodel,IOMODEL,solution_type,analysis_type,nummodels,i);
	}

	/*Free ressources:*/
	delete iomodel;

	/*Assign output pointers:*/
	*pelements=elements;
	*pnodes=nodes;
	*pvertices=vertices;
	*pmaterials=materials;
	*pconstraints=constraints;
	*ploads=loads;
	*pparameters=parameters;

}
