/*
 * DataSet.h: declaration of DataSet,Parameters and Inputs classes
 */

#ifndef _DATASET_H_
#define _DATASET_H_

#include <vector>
#include "../objects/Object.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

/*forward declarations */
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class DataSet;
class Inputs;


/********************************************************DATASET************************************************/
class DataSet{
	
	public: 
		
		/*internals: */
		std::vector<Object*> objects;
		
		/*type of dataset: */
		int             enum_type;
		
		/*sorting: */
		int             sorted;
		int             presorted;
		int*            sorted_ids;
		int*            id_offsets;

		/*constructors, destructors: {{{1*/
		DataSet();
		DataSet(int enum_type);
		~DataSet();
		/*}}}*/
		/*management: {{{1*/

		int   GetEnum();
		int   GetEnum(int offset);
		void  Echo();
		void  DeepEcho();
		char* Marshall();
		int   MarshallSize();
		int   AddObject(Object* object);
		int   DeleteObject(int id);
		int   Size();
		
		Object* FindParamObject(char* name);
		void  Ranks(int* ranks);
		void  DistributeDofs(int numberofnodes,int numdofspernode);
		void  CreatePartitioningVector(Vec* ppartition,int numobjects);
		void  FlagClones(int numberofnodes);
		int   NumberOfDofs(int analysis_type);
		int   NumberOfLocalRgbs(int analysis_type);
		int   NumberOfVertices(void);
		int   NumberOfNodes(void);
		int   NumberOfLoads(void);
		int   NumberOfConstraints(void);
		void  SetupSpcs(DataSet* nodes,Vec yg,int analysis_type);
		void  SetupMpcs(Mat Rmg,DataSet* nodes,int analysis_type);
		void  FlagNodeSets(Vec pv_g, Vec pv_m, Vec pv_n, Vec pv_f, Vec pv_s,int analysis_type);
		void  clear();
		void  Configure(Elements* elements,Loads* loads, DataSet* nodes, Vertices* vertices, DataSet* materials,Parameters* parameters);
		Object* GetObjectByOffset(int offset);
		Object* GetObjectById(int* poffset,int eid);
		void  Presort();
		void  SetSorting(int* in_sorted_ids,int* in_id_offsets);
		void  Sort();
		int   RiftIsPresent();
		int   MeltingIsPresent();
		void  MeltingConstraints(int* pconverged, int* pnum_unstable_constraints);
		DataSet* Copy(void);
		int   DeleteObject(Object* object);
		void  OutputRifts(Vec riftproperties);
		/*}}}*/

};

/*This routine cannot be object oriented, but need for demarshalling: */
DataSet* DataSetDemarshall(char* marshalled_dataset);
DataSet* DataSetDemarshallRaw(char** pmarshalled_dataset);


/********************************************************INPUT************************************************/

class Input;
class Node;

class Inputs: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Inputs();
		Inputs(int enum_type);
		~Inputs();
		/*}}}*/
		/*numerics: {{{1*/
		int  AddInput(Input* in_input);
		Input* GetInput(int enum_name);
		Inputs* SpawnTriaInputs(int* indices);
		Inputs* SpawnBeamInputs(int* indices);
		Inputs* SpawnSingInputs(int  index  );
		
		void GetParameterValue(bool* pvalue,int enum_type);
		void GetParameterValue(int* pvalue,int enum_type);
		void GetParameterValue(double* pvalue,int enum_type);
		void GetParameterValue(double* pvalue,Node* node,int enum_type);
		void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord,int enum_type);
		void GetParameterValue(double* pvalue,double* gauss,int enum_type);
		void GetParameterValue(double* pvalue,double* gauss,int enum_type,double defaultvalue);
		void GetParameterAverage(double* pvalue, int enum_type);
		
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type);
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type,double* defaultvalues);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss,int enum_type);
		void GetStrainRate2d(double* epsilon,double* xyz_list, double* gauss, int vxenum, int vyenum);
		void GetStrainRate3d(double* epsilon,double* xyz_list, double* gauss, int vxenum, int vyenum,int vzenum);
		void GetStrainRate3dPattyn(double* epsilon,double* xyz_list, double* gauss, int vxenum, int vyenum);

		void ChangeEnum(int enumtype,int new_enumtype);

		/*}}}*/

};


/********************************************************NODES************************************************/

class Nodes: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Nodes();
		Nodes(int enum_type);
		~Nodes();
		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};


/********************************************************VERTICES************************************************/

class Vertices: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Vertices();
		Vertices(int enum_type);
		~Vertices();
		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};


/********************************************************LOADS************************************************/

class Loads: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Loads();
		Loads(int enum_type);
		~Loads();
		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};

/********************************************************ELEMENTS************************************************/

class Elements: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Elements();
		Elements(int enum_type);
		~Elements();
		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};

/********************************************************CONSTRAINTS************************************************/

class Constraints: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Constraints();
		Constraints(int enum_type);
		~Constraints();
		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};




/********************************************************PARAMETERS************************************************/

class Parameters: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Parameters();
		Parameters(int enum_type);
		~Parameters();
		/*}}}*/
		/*numerics: {{{1*/
		int   FindParam(bool* pinteger,int enum_type);
		int   FindParam(int* pinteger,int enum_type);
		int   FindParam(double* pscalar, int enum_type);
		int   FindParam(char** pstring,int enum_type);
		int   FindParam(char*** pstringarray,int* pM,int enum_type);
		int   FindParam(double** pdoublearray,int* pM,int enum_type);
		int   FindParam(double** pdoublearray,int* pM,int* pN,int enum_type);
		int   FindParam(Vec* pvec,int enum_type);
		int   FindParam(Mat* pmat,int enum_type);
		
		void  SetParam(bool boolean,int enum_type);
		void  SetParam(int integer,int enum_type);
		void  SetParam(double scalar, int enum_type);
		void  SetParam(char* string,int enum_type);
		void  SetParam(char** stringarray,int M,int enum_type);
		void  SetParam(double* doublearray,int M,int enum_type);
		void  SetParam(double* doublearray,int M,int N,int enum_type);
		void  SetParam(Vec vec,int enum_type);
		void  SetParam(Mat mat,int enum_type);

		Object* FindParamObject(int enum_type);
		/*}}}*/

};


/********************************************************RESULTS************************************************/

class Results: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Results();
		Results(int enum_type);
		~Results();
		/*}}}*/
		/*numerics: {{{1*/
		Results* SpawnTriaResults(int* indices);
		Results* SpawnBeamResults(int* indices);
		Results* SpawnSingResults(int  index  );
		/*}}}*/

};



#endif
