/*\file InputToResult.c
 *\brief: duplicate input
 */

#include "./InputToResult.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	int      enum_type,step; 
	double   time;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputToResultUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	
	FetchData(&enum_type,ENUMTYPE);
	FetchData(&step,STEP);
	FetchData(&time,TIME);

	/*!Call core code: */
	InputToResultx( elements, nodes, vertices, loads, materials,parameters,enum_type, step,time);

	/*write output : */
	WriteData(ELEMENTSOUT,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void InputToResultUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, enum_type,step,time);\n",__FUNCT__);
	_printf_("\n");
}
