/*\file InputControlConstrain.c
*\brief: update elements properties using an input  vector
*/

#include "./InputControlConstrain.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

/*diverse: */
int         noerr             = 1;

/*input datasets: */
Elements*   elements          = NULL;
Nodes      *nodes             = NULL;
Vertices    *vertices          = NULL;
Loads     *loads             = NULL;
DataSet    *materials         = NULL;
Parameters *parameters        = NULL;
int         control_type;
double      cm_min;
double      cm_max;

/*Boot module: */
MODULEBOOT();

/*checks on arguments on the matlab side: */
CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputControlConstrainUsage);

/*Input datasets: */
FetchData((DataSet**)&elements,ELEMENTSIN);
FetchData((DataSet**)&nodes,NODESIN);
FetchData((DataSet**)&vertices,VERTICESIN);
FetchData((DataSet**)&loads,LOADSIN);
FetchData(&materials,MATERIALSIN);
FetchParams(&parameters,PARAMETERSIN);
FetchData(&control_type,CONTROLTYPE);
FetchData(&cm_min,CMMIN);
FetchData(&cm_max,CMMAX);

/*call "x" code layer*/
InputControlConstrainx(elements,nodes,vertices,loads, materials,parameters,control_type,cm_min,cm_max);

/*write output datasets: */
WriteData(ELEMENTS,elements);
WriteData(NODES,nodes);
WriteData(VERTICES,vertices);
WriteData(LOADS,loads);
WriteData(MATERIALS,materials);
WriteParams(PARAMETERS,parameters);

/*Free ressources: */
delete elements;
delete nodes;
delete vertices;
delete loads;
delete materials;
delete parameters;

/*end module: */
MODULEEND();
}

void InputControlConstrainUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,nodes,vertices,loads,materials,parameters] = %s(elements,nodes,vertices,loads,materials,parameters,control_type,cm_min,cm_max);\n",__FUNCT__);
	_printf_("\n");
}
