/*\file ConfigureObjects.c
 *\brief: configure objects (elements, loads for example), that need linking with nodes
 */

#include "./ConfigureObjects.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Elements* elements=NULL;
	Loads* loads=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;

	/* output datasets: elements and loads*/

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ConfigureObjectsUsage);
	
	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTSIN);
	FetchData((DataSet**)&loads,LOADSIN);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*!Configure objects:*/
	ConfigureObjectsx(elements, loads, nodes, vertices,materials,parameters);

	/*write output datasets: */
	WriteData(ELEMENTS,elements);
	WriteData(LOADS,loads);
	WriteData(NODESOUT,nodes);
	WriteParams(PARAMETERSOUT,parameters);

	/*Free ressources: */
	delete elements;
	delete loads;
	delete nodes;
	delete vertices;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void ConfigureObjectsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,loads, nodes,parameters] = %s(elements,loads,nodes, materials,parameters);\n",__FUNCT__);
	_printf_("\n");
}
