/*\file ComputePressure.c
 *\brief: recover pressure from elements
 */

#include "./ComputePressure.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL; 
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	int      numberofnodes;
	int      analysis_type;
	int      sub_analysis_type;

	/* output datasets: */
	Vec p_g=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ComputePressureUsage);
        
	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&analysis_type,ANALYSIS);
	FetchData(&sub_analysis_type,SUBANALYSIS);

	/*!Generate internal degree of freedom numbers: */
	ComputePressurex(&p_g, elements,nodes,vertices,loads,materials,parameters,analysis_type,sub_analysis_type);

	/*write output datasets: */
	WriteData(PRESSURE,p_g);

	/*Free ressources: */
	delete nodes;
	delete vertices;
	delete elements;
	delete materials;
	delete loads;
	delete parameters;
	VecFree(&p_g);

	/*end module: */
	MODULEEND();
}

void ComputePressureUsage(void) {
	printf("\n");
	printf("   usage: [p_g] = %s(elements, nodes, vertices, loads, materials, params);\n",__FUNCT__);
	printf("\n");
}
