/*\file PenaltySystemMatrices.c
 *\brief: build penalty matrices
 */

#include "./PenaltySystemMatrices.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*output: */
	double kmax;

	/*input datasets: */
	Mat      Kgg=NULL;
	Vec      pg=NULL;
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	int      kflag,pflag;
	
	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&PenaltySystemMatricesUsage);

	/*Input datasets: */
	FetchData(&Kgg,KGGIN);
	FetchData(&pg,PGIN);
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	
	/*parameters: */
	parameters->FindParam(&kflag,KflagEnum);
	parameters->FindParam(&pflag,PflagEnum);

	/*!Generate stiffnesses from penalties: */
	PenaltySystemMatricesx(Kgg, pg,&kmax,elements,nodes,vertices,loads,materials,parameters,kflag,pflag);

	/*write output datasets: */
	WriteData(KGG,Kgg);
	WriteData(PG,pg);
	WriteData(KMAX,kmax);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	MatFree(&Kgg);
	VecFree(&pg);

	/*end module: */
	MODULEEND();
}

void PenaltySystemMatricesUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Kgg,pg] = %s(Kggin,pgin,elements,nodes,vertices,loads,materials,params);\n",__FUNCT__);
	_printf_("\n");
}
