/*!\file Riftfront.h
 * \brief: header file for riftfront object
 */

#ifndef _RIFTFRONT_H_
#define _RIFTFRONT_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;

#define MAX_RIFTFRONT_GRIDS 2 //max number of grids on a rift flank, only 2 because 2d for now.
#define RIFTFRONTSTRING 20 //max string length
/*}}}*/

class Riftfront: public Load {

	public:
		int		id;
		int     analysis_type;

		Hook hnodes; //2 nodes
		Hook helements; //2 elements
		Hook hmatpar;
		
		/*computational: */
		int      penalty_lock;
		bool     active;
		bool     frozen;
		int      counter;
		bool     prestable;
		bool     material_converged;
		double   normal[2];
		double   length;
		double   fraction;
		
		Parameters* parameters; //pointer to solution parameters
		Inputs*  inputs;


		/*constructors,destructors: {{{1*/
		Riftfront();
		Riftfront(int riftfront_id,int i, IoModel* iomodel,int analysis_type);
		~Riftfront();
		/*}}}*/
		/*object management: {{{1*/
		void  Configure(Elements* elements,Loads* loads,DataSet* nodes,Vertices* vertices,DataSet* materials,Parameters* parameters);
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void    InputUpdateFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		bool    InAnalysis(int analysis_type);



		/*}}}*/
		/*numerics: {{{1*/
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  CreateKMatrix(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax);
		void  PenaltyCreatePVector(Vec pg,double kmax);
		bool  PreStable();
		void  SetPreStable();
		int   PreConstrain(int* punstable);
		int   Constrain(int* punstable);
		void  FreezeConstraints(void);
		bool  IsFrozen(void);
		int   Penetration(double* ppenetration);
		int   MaxPenetration(double* ppenetration);
		int   PotentialUnstableConstraint(int* punstable);
		int   IsMaterialStable(void);
		void  OutputProperties(Vec riftproperties);
		/*}}}*/
};

#endif  /* _RIFTFRONT_H_ */
