/*!\file:  Load.h
 * \brief abstract class for Load object
 * This class is a place holder for the Icefront  and the Penpair loads.
 * It is derived from Load, so DataSets can contain them.
 */ 


#ifndef _LOAD_H_
#define _LOAD_H_

/*Headers:*/
/*{{{1*/
class Object;

#include "../Object.h"
#include "../../toolkits/toolkits.h"
#include "../../DataSet/DataSet.h"
/*}}}*/

class Load: public Object{

	public: 
		virtual       ~Load(){};
		virtual void  Echo()=0;
		virtual void  DeepEcho()=0;
		virtual int   Id()=0;
		virtual int   MyRank()=0;
		virtual void  Marshall(char** pmarshalled_dataset)=0;
		virtual int   MarshallSize()=0;
		virtual void  Demarshall(char** pmarshalled_dataset)=0;
		virtual void  Configure(Elements* elements,Loads* loads,DataSet* nodes,Vertices* vertices,DataSet* materials,Parameters* parameters)=0;
		virtual void  CreateKMatrix(Mat Kgg)=0;
		virtual void  CreatePVector(Vec pg)=0;
		virtual void  PenaltyCreateKMatrix(Mat Kgg,double kmax)=0;
		virtual void  PenaltyCreatePVector(Vec pg,double kmax)=0;
		virtual bool  InAnalysis(int analysis_type)=0;
};
#endif
