/*!\file InputScalex
 * \brief: duplicte  an input inside the elements, onto another, and wipe it off.
 */

#include "./InputScalex.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputScalex(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,DataSet* materials,Parameters* parameters,int enum_type, double scale_factor){

	/*intermediary:*/
	int      i;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elemnets, and ask to reinitialie the input: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputScale(enum_type,scale_factor);
	}

}
