/*\file OutputRifts.c
 *\brief: output rift properties (fraction, penetration, etc ...)
 */

#include "./OutputRifts.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;
	int   numrifts;

	/*input datasets: */
	Loads* loads=NULL;

	/* output datasets: */
	Vec riftproperties=NULL;


	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&OutputRiftsUsage);

	/*Input datasets: */
	FetchData((DataSet**)&loads,LOADS);
	FetchData(&numrifts,mxGetField(PARAMETERS,0,"numrifts"));

	/*!Call core code: */
	OutputRiftsx(&riftproperties,loads,numrifts);

	/*write output : */
	WriteData(RIFTPROPERTIES,riftproperties);

	/*Free ressources: */
	delete loads;
	VecFree(&riftproperties);

	/*end module: */
	MODULEEND();
}

void OutputRiftsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [riftproperties] = %s(loads,parameters);\n",__FUNCT__);
	_printf_("\n");
}
