/*\file ModelProcessor.c
 *\brief: processes model inputs from the matlab workspace, and transforms them into datasets or vectors 
 *        that will be used throughout the matlab solution sequences.
 */

#include "./ModelProcessor.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){ 

	int i;

	/*inputs: */
	int     solution_type;
	double* double_analyses=NULL;
	int*    analyses=NULL;
	int     numanalyses;

	/* output datasets: */
	DataSet* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	DataSet* constraints=NULL;
	Loads* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ModelProcessorUsage);

	FetchData(&solution_type,SOLUTIONTYPE);
	
	FetchData(&double_analyses,&numanalyses,ANALYSES);
	analyses=(int*)xmalloc(numanalyses*sizeof(int));
	for(i=0;i<numanalyses;i++)analyses[i]=double_analyses[i];

	/*call x code ModelProcessorx: */
	ModelProcessorx(&elements,&nodes,&vertices,&materials,&constraints, &loads, &parameters, MODEL,solution_type,numanalyses,analyses);

	/*Write output data: */
	WriteData(ELEMENTS,elements);
	WriteData(NODES,nodes);
	WriteData(VERTICES,vertices);
	WriteData(CONSTRAINTS,constraints);
	WriteData(LOADS,loads);
	WriteData(MATERIALS,materials);
	WriteParams(PARAMETERS,parameters);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete constraints;
	delete loads;
	delete materials;
	delete parameters;
	xfree((void**)&analyses);
	xfree((void**)&double_analyses);
	
	/*end module: */
	MODULEEND();
}
	
void ModelProcessorUsage(void) {
	_printf_("\n");
	_printf_("   usage: [elements,grids,constraints,loads,materials,parameters,part,tpart]=ModelProcessor(model,analyses)\n");
	_printf_("   where: model is an instance of the matlab @model class and analyses is a list of analysis types being performed.\n");
	_printf_("\n");
}
