/*!\file Penpair.h
 * \brief: header file for penpair object */

#ifndef _PENPAIR_H_
#define _PENPAIR_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
#include "../Node.h"
#include "../Elements/Element.h"

class Element;
/*}}}*/

class Penpair: public Load{

	private: 
		int		id;
		int analysis_type;
		
		Hook hnodes;  //hook to 2 nodes

	public:

		/*constructors: {{{1*/
		Penpair();
		Penpair(int penpair_id,int* penpair_node_ids,int analysis_type);
		Penpair(int penpair_id,Hook* penpair_hnodes,int analysis_type);
		~Penpair();
		Object* copy();
		/*}}}*/
		/*object management: {{{1*/
		void  Configure(DataSet* elements,Loads* loads,DataSet* nodes,Vertices* vertices,DataSet* materials,Parameters* parameters);
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  InputUpdateFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*numerics: {{{1*/
		void  CreateKMatrix(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax);
		void  PenaltyCreatePVector(Vec pg,double kmax);
		/*}}}*/
};

#endif  /* _PENPAIR_H_ */


