/*!\file RiftConstraints.h
 * \brief: manage penalties for rifts 
 */


#ifndef _RIFTCONSTRAINTS_H_
#define _RIFTCONSTRAINTS_H_

#include "../../objects/objects.h"
#include "../../DataSet/DataSet.h"

int RiftConstraints(int* pconverged, int* pnum_unstable_constraints,Loads* loads,int min_mechanical_constraints);

int RiftIsPresent(Loads* loads);

int IsPreStable(Loads* loads);

int SetPreStable(Loads* loads);

int PreConstrain(int* pnum_unstable_constraints,Loads* loads);

int Constrain(int* pnum_unstable_constraints,Loads* loads);

void FreezeConstraints(Loads* loads);

int MaxPenetrationInInputs(Loads* loads);

int PotentialUnstableConstraints(Loads* loads);

int IsMaterialStable(Loads* loads);

int IsFrozen(Loads* loads);
#endif
