/*!\file InputToResultx
 * \brief: transfer an input to the results  dataset inside the elements
 */

#include "./InputToResultx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputToResultx(DataSet* elements,Nodes* nodes,Vertices* vertices,Loads* loads,DataSet* materials,Parameters* parameters,int enum_type,int step, double time){

	/*intermediary:*/
	int      i;
	Element *element = NULL;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elemnets, and ask each element to transfer the enum_type input into the results dataset, with step and time information: */
	 
	for(i=0;i<elements->Size();i++){

		element=(Element*)elements->GetObjectByOffset(i);
		element->InputToResult(enum_type,step,time);
	}

}
