/*!\file GetVectorFromInputsx
 * \brief retrieve vector from inputs in elements
 */

#include "./GetVectorFromInputsx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void GetVectorFromInputsx( Vec* pvector, DataSet* elements,Nodes* nodes, Vertices* vertices, Loads* loads, DataSet* materials, Parameters* parameters, int NameEnum, int TypeEnum){


	int i;
	Vec vector=NULL;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);


	if(TypeEnum==VertexEnum){

		vector=NewVec(vertices->Size());
		for(i=0;i<elements->Size();i++){
			Element* element=(Element*)elements->GetObjectByOffset(i);
			element->GetVectorFromInputs(vector,NameEnum);
		}
	}
	else ISSMERROR("%s%s%s"," vector type: ",EnumAsString(TypeEnum)," not supported yet!");

	VecAssemblyBegin(vector);
	VecAssemblyEnd(vector);

	/*Assign output pointers:*/
	*pvector=vector;

}

void GetVectorFromInputsx( double** pvector, DataSet* elements,Nodes* nodes, Vertices* vertices, Loads* loads, DataSet* materials, Parameters* parameters, int NameEnum, int TypeEnum){
	
	/*output: */
	double* vector=NULL;
	
	/*intermediary: */
	Vec vec_vector=NULL;

	GetVectorFromInputsx( &vec_vector, elements,nodes, vertices, loads, materials, parameters, NameEnum, TypeEnum);
	VecToMPISerial(&vector,vec_vector);

	/*Free ressources:*/
	VecFree(&vec_vector);

	/*Assign output pointers:*/
	*pvector=vector;
}
