/*!\file Penpair.c
 * \brief: implementation of the Penpair object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
		
/*Object constructors and destructor*/
/*FUNCTION Penpair::constructor {{{1*/
Penpair::Penpair(){
	return;
}
/*}}}1*/
/*FUNCTION Penpair::creation {{{1*/
Penpair::Penpair(int penpair_id, int* penpair_node_ids,int in_analysis_type):
	hnodes(penpair_node_ids,2)
{

	/*all the initialization has been done by the initializer, just fill in the id: */
	this->id=penpair_id;
	this->analysis_type=in_analysis_type;
	
	return;
}
/*}}}1*/
/*FUNCTION Penpair::creation {{{1*/
Penpair::Penpair(int penpair_id, Hook* penpair_hnodes,int in_analysis_type):
	hnodes(penpair_hnodes)
{

	/*all the initialization has been done by the initializer, just fill in the id: */
	this->id=penpair_id;
	this->analysis_type=in_analysis_type;
	
	return;
}
/*}}}1*/
/*FUNCTION Penpair::copy {{{1*/
Object* Penpair::copy() {
	
	Penpair* penpair=NULL;

	penpair=new Penpair();

	/*copy fields: */
	penpair->id=this->id;
	penpair->analysis_type=this->analysis_type;

	/*now deal with hooks and objects: */
	penpair->hnodes.copy(&this->hnodes);

	return penpair;

}
/*}}}*/
/*FUNCTION Penpair::destructor {{{1*/
Penpair::~Penpair(){
	return;
}
/*}}}1*/
		
/*Object marshall*/
/*FUNCTION Penpair::Configure {{{1*/
void  Penpair::Configure(DataSet* elementsin,Loads* loadsin,DataSet* nodesin,Vertices* verticesin,DataSet* materialsin,Parameters* parametersin){

	/*Take care of hooking up all objects for this element, ie links the objects in the hooks to their respective 
	 * datasets, using internal ids and offsets hidden in hooks: */
	hnodes.configure(nodesin);

}
/*}}}1*/
/*FUNCTION Penpair::DeepEcho {{{1*/
void Penpair::DeepEcho(void){

	printf("Penpair:\n");
	printf("   id: %i\n",id);
	printf("   analysis_type: %s\n",EnumAsString(analysis_type));
	hnodes.DeepEcho();

	return;
}		
/*}}}1*/
/*FUNCTION Penpair::Demarshall {{{1*/
void  Penpair::Demarshall(char** pmarshalled_dataset){

	int i;
	char* marshalled_dataset=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&analysis_type,marshalled_dataset,sizeof(analysis_type));marshalled_dataset+=sizeof(analysis_type);

	/*demarshall hooks: */
	hnodes.Demarshall(&marshalled_dataset);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}1*/
/*FUNCTION Penpair::Echo {{{1*/
void Penpair::Echo(void){

	int i;

	printf("Penpair:\n");
	printf("   id: %i\n",id);
	printf("   analysis_type: %s\n",EnumAsString(analysis_type));
	hnodes.Echo();
	
	return;
}
/*}}}1*/
/*FUNCTION Penpair::Enum {{{1*/
int Penpair::Enum(void){

	return PenpairEnum;
}
/*}}}1*/
/*FUNCTION Penpair::Id {{{1*/
int    Penpair::Id(void){ return id; }
/*}}}1*/
/*FUNCTION Penpair::Marshall {{{1*/
void  Penpair::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Penpair: */
	enum_type=PenpairEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall Penpair data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&analysis_type,sizeof(analysis_type));marshalled_dataset+=sizeof(analysis_type);

	/*Marshall hooks*/
	hnodes.Marshall(&marshalled_dataset);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}1*/
/*FUNCTION Penpair::MarshallSize {{{1*/
int   Penpair::MarshallSize(){

	return sizeof(id)+
		+sizeof(analysis_type)
		+hnodes.MarshallSize()
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}1*/
/*FUNCTION Penpair::MyRank {{{1*/
int    Penpair::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}1*/

/*Object functions*/
/*FUNCTION Penpair::CreateKMatrix {{{1*/
void  Penpair::CreateKMatrix(Mat Kgg){

	/*No loads applied, do nothing: */
	return;

}
/*}}}1*/
/*FUNCTION Penpair::CreatePVector {{{1*/
void  Penpair::CreatePVector(Vec pg){

	/*No loads applied, do nothing: */
	return;

}
/*}}}1*/
/*FUNCTION Penpair::PenaltyCreateKMatrix {{{1*/
void  Penpair::PenaltyCreateKMatrix(Mat Kgg,double kmax){
	
	/*If you code this piece, don't forget that a penalty will be inactive if it is dealing with clone nodes*/
	/*No loads applied, do nothing: */
	return;
}
/*}}}1*/
/*FUNCTION Penpair::PenaltyCreatePVector {{{1*/
void  Penpair::PenaltyCreatePVector(Vec pg,double kmax){
	/*No loads applied, do nothing: */
	return;
}
/*}}}1*/
/*FUNCTION Penpair::InAnalysis(int analysis_type){{{1*/
bool Penpair::InAnalysis(int in_analysis_type){
	if (in_analysis_type=this->analysis_type)return true;
	else return false;
}
/*}}}*/
