/*! \file CreateLoadsBalancedthickness2.c:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../io/io.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsBalancedthickness2(Loads** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;

	/*Output*/
	Loads* loads=NULL;

	/*Recover pointer: */
	loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads(LoadsEnum);

	/*Get edges and elements*/
	IoModelFetchData(&iomodel->edges,&iomodel->numberofedges,NULL,iomodel_handle,"edges");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");

	/*First load data:*/
	for (i=0;i<iomodel->numberofedges;i++){
		loads->AddObject(new Numericalflux(iomodel->loadcounter+i+1,i,iomodel,Balancedthickness2AnalysisEnum));
	}

	/*Free data: */
	xfree((void**)&iomodel->edges);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->thickness);

	/*Assign output pointer: */
	*ploads=loads;
}
