/*! \file Tria.h 
 *  \brief: header file for tria object
 */

#ifndef _TRIA_H_
#define _TRIA_H_

/*Headers:*/
/*{{{1*/
#include "./Element.h"
#include "./TriaHook.h"
#include "./TriaRef.h"
class Parameters;
class Inputs;
class IoModel;
class Node;
class Matice;
class Matpar;

#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
/*}}}*/

class Tria: public Element,public TriaHook,public TriaRef{

	public:

		int  id;

		Node** nodes; // 3 nodes
		Matice* matice;  // 1 material ice
		Matpar* matpar;  // 1 material parameter
 
		Parameters* parameters; //pointer to solution parameters
		Inputs*  inputs;
		Results*  results; 

		/*FUNCTION constructors, destructors {{{1*/
		Tria();
		Tria(int tria_id,int i, IoModel* iomodel,int nummodels);
		void  Update(int index,IoModel* iomodel,int analysis_counter,int analysis_type);
		void  UpdateGeometry(void);
		~Tria();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		void  Configure(DataSet* elements,Loads* loads,DataSet* nodes,DataSet* materials,Parameters* parameters);
		Object* copy();
		void  DeepEcho(void);
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo(void);
		int   Enum(void);
		int   Id(void); 
		bool  IsInput(int name);
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize(void);
		int   MyRank(void);
		void  SetClone(int* minranks);
		void  InputDepthAverageAtBase(int enum_type,int average_enum_type);
		void*  SpawnSing(int g0);
		void*  SpawnBeam(int g0, int g1);
		void  InputToResult(int enum_type,int step,double time);
		void   ProcessResultsUnits(void);
		/*}}}*/
		/*FUNCTION element numerical routines {{{1*/
		void  CreateKMatrix(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  GetSolutionFromInputs(Vec solution);
		void  GetSolutionFromInputsDiagnosticHoriz(Vec solution);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void  CreateKMatrixDiagnosticHutter(Mat Kgg);
		void  CreateKMatrixDiagnosticHoriz(Mat Kgg);
		void  CreateKMatrixDiagnosticHorizFriction(Mat Kgg);
		void  CreateKMatrixDiagnosticSurfaceVert(Mat Kgg);
		void  CreateKMatrixSlopeCompute(Mat Kgg);
		void  GetParameterValue(double* pp, double* plist, double* gauss_l1l2l3);
		void  GetParameterDerivativeValue(double* p, double* plist,double* xyz_list, double* gauss_l1l2l3);
		void  GetJacobianDeterminant2d(double*  Jdet, double* xyz_list,double* gauss_l1l2l3);
		void  GetJacobianDeterminant3d(double*  Jdet, double* xyz_list,double* gauss_l1l2l3);
		void  GetB(double* B, double* xyz_list, double* gauss_l1l2l3);
		void  GetBPrime(double* Bprime, double* xyz_list, double* gauss_l1l2l3);
		void  GetL(double* L, double* xyz_list, double* gauss_l1l2l3,int numdof);
		void  GetB_prog(double* B_prog, double* xyz_list, double* gauss_l1l2l3);
		void  GetBPrime_prog(double* Bprime_prog, double* xyz_list, double* gauss_l1l2l3);
		void  GetNodalFunctions(double* l1l2l3, double* gauss_l1l2l3);
		void  GetNodalFunctionsDerivatives(double* dh1dh3,double* xyz_list, double* gauss_l1l2l3);
		void  GetNodalFunctionsDerivativesReference(double* dl1dl3,double* gauss_l1l2l3);
		void  GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss_l1l2l3);
		void  GetJacobian(double* J, double* xyz_list,double* gauss_l1l2l3);
		void  Du(Vec du_g);
		void  Gradj(Vec gradient,int control_type);
		void  GradjDrag(Vec gradient);
		void  GradjDragStokes(Vec gradient);
		void  GradjB(Vec gradient);
		void  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		double Misfit(void);
		double SurfaceArea(void);
		double CostFunction(void);
		void  CreatePVectorDiagnosticHutter(Vec pg);
		void  CreatePVectorDiagnosticHoriz(Vec pg);
		void  CreatePVectorDiagnosticBaseVert(Vec pg);
		void  CreatePVectorSlopeCompute( Vec pg);
		void* GetMatPar(void);
		bool  GetShelf(void);
		void  GetNodes(void** nodes);
		bool  GetOnBed(void);
		void  GetThicknessList(double* thickness_list);
		void  GetBedList(double* bed_list);
		void  ComputeBasalStress(Vec sigma_b);
		void  ComputePressure(Vec p_g);
		void  ComputeStrainRate(Vec eps);
		void  CreateKMatrixThermal(Mat Kgg);
		void  CreateKMatrixMelting(Mat Kgg);
		void  CreatePVectorThermalShelf( Vec pg);
		void  CreatePVectorThermalSheet( Vec pg);
		void  CreateKMatrixPrognostic(Mat Kgg);
		void  CreatePVectorPrognostic(Vec pg);
		void  CreateKMatrixPrognostic2(Mat Kgg);
		void  CreatePVectorPrognostic2(Vec pg);
		void  CreateKMatrixBalancedthickness(Mat Kgg);
		void  CreatePVectorBalancedthickness(Vec pg);
		void  CreateKMatrixBalancedthickness2(Mat Kgg);
		void  CreatePVectorBalancedthickness2(Vec pg);
		void  CreateKMatrixBalancedvelocities(Mat Kgg);
		void  CreatePVectorBalancedvelocities(Vec pg);
		double MassFlux(double* segment);
		double GetArea(void);
		double GetAreaCoordinate(double x, double y, int which_one);
		void  PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes);
		void  PatchFill(int* pcount, Patch* patch);
		void  MinVel(double* pminvel, bool process_units);
		void  MaxVel(double* pmaxvel, bool process_units);
		void  MinVx(double* pminvx, bool process_units);
		void  MaxVx(double* pmaxvx, bool process_units);
		void  MaxAbsVx(double* pmaxabsvx, bool process_units);
		void  MinVy(double* pminvy, bool process_units);
		void  MaxVy(double* pmaxvy, bool process_units);
		void  MaxAbsVy(double* pmaxabsvy, bool process_units);
		void  MinVz(double* pminvz, bool process_units);
		void  MaxVz(double* pmaxvz, bool process_units);
		void  MaxAbsVz(double* pmaxabsvz, bool process_units);
		void  InputDuplicate(int original_enum,int new_enum);
		void  InputScale(int enum_type,double scale_factor);
		void  InputAXPY(int YEnum, double scalar, int XEnum);
		void  InputConvergence(int* pconverged,double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums);
		void  InputControlConstrain(int control_type,double cm_min, double cm_max);
		void  GetVectorFromInputs(Vec vector,int NameEnum);


		/*}}}*/
		/*FUNCTION updates{{{1*/
		void  UpdateFromDakota(void* inputs);
		void  InputUpdateFromSolution(double* solutiong);
		void  InputUpdateFromSolutionDiagnosticHoriz( double* solution);
		void  InputUpdateFromSolutionSlopeCompute( double* solution);
		void  InputUpdateFromSolutionPrognostic( double* solution);
		void  InputUpdateFromSolutionPrognostic2(double* solution);
		void  InputUpdateFromSolutionBalancedthickness( double* solution);
		void  InputUpdateFromSolutionBalancedthickness2( double* solution);
		void  InputUpdateFromSolutionBalancedvelocities( double* solution);
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		/*}}}*/

};
#endif  /* _TRIA_H */
