/*!\file VecExtrudex
 * \brief: vertical velocity extrusion
 */

#include "./VecExtrudex.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void VecExtrudex( Vec vector, DataSet* elements,Nodes* nodes, Vertices* vertices, Loads* loads, DataSet* materials, Parameters* parameters,int collapse){

	double* vector_serial=NULL;
	int i;
	Element* element=NULL;
	Penta*   penta=NULL;
	Node*    node=NULL;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Serialize vector: */
	VecToMPISerial(&vector_serial,vector);

	/*ok, is the extrusion dependent upon elements or just nodes? If collapse is 1, it means we only want 
	 * to extrude the vector on elemenets that are collapsed (element operation). If collapse is 0, it means 
	 * we want to extrude vector on every node (node operation): */

	if(collapse){
		/*Extrude vector vertically: */
		for(i=0;i<elements->Size();i++){
			element=(Element*)elements->GetObjectByOffset(i);
			if(element->Enum()==PentaEnum){
				penta=(Penta*)element;
				penta->VecExtrude(vector,vector_serial,collapse);
			}
		}
	}
	else{
		for(i=0;i<nodes->Size();i++){
			node=(Node*)nodes->GetObjectByOffset(i);
			node->VecExtrude(vector,vector_serial);
		}
	}

	/*Assemble vector: */
	VecAssemblyBegin(vector);
	VecAssemblyEnd(vector);

	/*Free ressources:*/
	xfree((void**)&vector_serial);

}
