/*!\file MinVzx
 */

#include "./MinVzx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void MinVzx( double* pminvz, DataSet* elements,Nodes* nodes, Vertices* vertices, Loads* loads, DataSet* materials,Parameters* parameters){
	
	int i;
	double minvz;
	double node_minvz;
	bool   process_units=true;
	double element_minvz;

	/*First, configure elements:*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MinVz(&element_minvz,process_units); //go pick up the minimum velocity in the inputs
	
		if(i==0)minvz=element_minvz; //initialize minvz
		else{
			if(element_minvz<minvz)minvz=element_minvz;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		minvz=INFINITY;
	}

	#ifdef _PARALLEL_
	/*Figure out minimum across the cluster: */
	MPI_Reduce (&minvz,&node_minvz,1,MPI_DOUBLE,MPI_MIN,0,MPI_COMM_WORLD );
	MPI_Bcast(&node_minvz,1,MPI_DOUBLE,0,MPI_COMM_WORLD);   
	minvz=node_minvz;
	#endif

	/*Assign output pointers:*/
	*pminvz=minvz;
}
