/*!\file MassFluxx
 * \brief: compute mass flux along a profile.
 */

#include "./MassFluxx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MassFluxx(double* pmass_flux, DataSet* elements,Nodes* nodes, Vertices* vertices,Loads* loads,DataSet* materials,Parameters* parameters,  double* segments,int num_segments){

	int i,j;
	extern int num_procs;
	extern int my_rank;
	
	Element* element=NULL;
	int element_id;
	
	/*output: */
	double mass_flux=0;
	double all_mass_flux=0;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through segments, and then elements, and figure out which elements belong to a segment. 
	 * When we find one, use the element to compute the mass flux on the segment: */

	for(i=0;i<num_segments;i++){
		element_id=(int)*(segments+5*i+4);
		for(j=0;j<elements->Size();j++){
			element=(Element*)elements->GetObjectByOffset(j);
			if (element->Id()==element_id){
				/*We found the element which owns this segment, use it to compute the mass flux: */
				mass_flux+=element->MassFlux(segments+5*i+0);
				break;
			}
		}
	}

	#ifdef _PARALLEL_
	MPI_Allreduce ( (void*)&mass_flux,(void*)&all_mass_flux,1,MPI_DOUBLE,MPI_SUM,MPI_COMM_WORLD);
	mass_flux=all_mass_flux;
	#endif

	/*Assign output pointers: */
	*pmass_flux=mass_flux;
}
