/*!\file ComputePressurex
 * \brief: compute pressure according to each element
 */

#include "./ComputePressurex.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void	ComputePressurex( Vec* pp_g,DataSet* elements,Nodes* nodes, Vertices* vertices,Loads* loads, DataSet* materials,Parameters* parameters){

	/*intermediary*/
	int numberofnodes;
	int i;
	Element* element=NULL;

	/*output: */
	Vec p_g=NULL;

	/*Recover numberofnodes: */
	numberofnodes=nodes->NumberOfNodes();

	/*Allocate p_g on numberofnodes (only 1 dof): */
	p_g=NewVec(numberofnodes);

	/*Get elements configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements,loads,nodes,vertices,materials,parameters);
	parameters->Configure(elements,loads,nodes,vertices,materials,parameters);

	/*Compute pressure for each element: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->ComputePressure(p_g);
	}

	/*Assemble vector: */
	VecAssemblyBegin(p_g);
	VecAssemblyEnd(p_g);

	/*Assign output pointers: */
	*pp_g=p_g;
	
}
