/*!\file MinVyx
 */

#include "./MinVyx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void MinVyx( double* pminvy, DataSet* elements,Nodes* nodes, Vertices* vertices, DataSet* loads, DataSet* materials,Parameters* parameters){
	
	int i;
	double minvy;
	double node_minvy;
	bool   process_units=true;
	double element_minvy;

	/*First, configure elements:*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MinVy(&element_minvy,process_units); //go pick up the minimum velocity in the inputs
	
		if(i==0)minvy=element_minvy; //initialize minvy
		else{
			if(element_minvy<minvy)minvy=element_minvy;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		minvy=INFINITY;
	}

	#ifdef _PARALLEL_
	/*Figure out minimum across the cluster: */
	MPI_Reduce (&minvy,&node_minvy,1,MPI_DOUBLE,MPI_MIN,0,MPI_COMM_WORLD );
	MPI_Bcast(&node_minvy,1,MPI_DOUBLE,0,MPI_COMM_WORLD);   
	minvy=node_minvy;
	#endif

	/*Assign output pointers:*/
	*pminvy=minvy;
}
