/*\file UpdateVertexPositions.c
*\brief: update elements properties using an input  vector
*/

#include "./UpdateVertexPositions.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

/*diverse: */
int         noerr             = 1;

/*input datasets: */
DataSet    *elements          = NULL;
Nodes      *nodes             = NULL;
Vertices    *vertices          = NULL;
DataSet    *loads             = NULL;
DataSet    *materials         = NULL;
Parameters *parameters        = NULL;

/*Boot module: */
MODULEBOOT();

/*checks on arguments on the matlab side: */
CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateVertexPositionsUsage);

/*Input datasets: */
FetchData(&elements,ELEMENTSIN);
FetchData((DataSet**)&nodes,NODESIN);
FetchData((DataSet**)&vertices,VERTICESIN);
FetchData(&loads,LOADSIN);
FetchData(&materials,MATERIALSIN);
FetchParams(&parameters,PARAMETERSIN);

/*call "x" code layer*/
UpdateVertexPositionsx(elements,nodes,vertices,loads, materials,parameters);

/*write output datasets: */
WriteData(ELEMENTS,elements);
WriteData(NODES,nodes);
WriteData(VERTICES,vertices);
WriteData(LOADS,loads);
WriteData(MATERIALS,materials);
WriteParams(PARAMETERS,parameters);

/*Free ressources: */
delete elements;
delete nodes;
delete vertices;
delete loads;
delete materials;
delete parameters;

/*end module: */
MODULEEND();
}

void UpdateVertexPositionsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,nodes,vertices,loads,materials,parameters] = %s(elements,nodes,vertices,loads,materials,parameters);\n",__FUNCT__);
	_printf_("\n");
}
