/*\file FieldAverageOntoVertices.c
 *\brief: average field throfieldh thickness
 */

#include "./FieldAverageOntoVertices.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	Vec      field=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&FieldAverageOntoVerticesUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&field,FIELD);

	/*!Call core code: */
	FieldAverageOntoVerticesx(&field,elements,nodes,vertices,loads,materials,parameters);

	/*write output : */
	WriteData(FIELDOUT,field);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	VecFree(&field);
	
	/*end module: */
	MODULEEND();

}

void FieldAverageOntoVerticesUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [field] = %s(elements, nodes,loads, materials, parameters,field);\n",__FUNCT__);
	_printf_("\n");
}
