/* \file ModelProcessorx.h
 * \brief  Header file for model processor
 */

#ifndef _MODEL_PROCESSORX_H_
#define _MODEL_PROCESSORX_H_

#define RIFTINFOSIZE 11

class DataSet;
class IoModel;
class Parameters;
#include "../../io/io.h"

void ModelProcessorx(DataSet** pelements, Nodes** pnodes, Vertices** pvertices, DataSet** pmaterials, DataSet** pconstraints, DataSet** ploads, Parameters** pparameters, ConstDataHandle iomodel_handle,int solution_type,int nummodels, int* analysis_type_list);

/*Creation of fem datasets: general drivers*/
void  CreateDataSets(DataSet** pelements,Nodes** pnodes,Vertices** pvertices, DataSet** pmaterials, DataSet** pconstraints, DataSet** ploads,Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int solution_type,int analysis_type,int nummodels,int analysis_counter);
void  CreateElementsVerticesAndMaterials(DataSet** pelements,Vertices** pvertices,DataSet** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle,int nummodels);
void  CreateParameters(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int solution_type,int analysis_type,int analysis_counter);
void  CreateParametersControl(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int analysis_type);
void  CreateParametersQmu(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int analysis_type);

/*Creation of fem datasets: specialised drivers: */

/*diagnostic horizontal*/
void	CreateNodesDiagnosticHoriz(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticHoriz(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsDiagnosticHoriz(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticHoriz(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic vertical*/
void	CreateNodesDiagnosticVert(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticVert(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsDiagnosticVert(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticVert(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic hutter*/
void	CreateNodesDiagnosticHutter(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticHutter(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsDiagnosticHutter(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticHutter(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic stokes*/
void	CreateNodesDiagnosticStokes(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticStokes(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsDiagnosticStokes(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticStokes(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*slope compute*/
void	CreateNodesSlopeCompute(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsSlopeCompute(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsSlopeCompute(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsSlopeCompute(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*thermal:*/
void	CreateNodesThermal(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsThermal(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsThermal(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsThermal(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*melting:*/
void	CreateNodesMelting(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsMelting(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsMelting(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsMelting(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*prognostic:*/
void	CreateNodesPrognostic(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsPrognostic(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsPrognostic(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsPrognostic(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*prognostic2:*/
void	CreateNodesPrognostic2(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsPrognostic2(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsPrognostic2(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsPrognostic2(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*balancedthickness:*/
void	CreateNodesBalancedthickness(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedthickness(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsBalancedthickness(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsBalancedthickness(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

void	CreateNodesBalancedthickness2(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedthickness2(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsBalancedthickness2(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsBalancedthickness2(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*balancedvelocities:*/
void	CreateNodesBalancedvelocities(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedvelocities(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsBalancedvelocities(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsBalancedvelocities(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*partitioning: */
void  ElementsAndVerticesPartitioning(bool** pmy_elements, bool** pmy_vertices, bool** pmy_bordervertices, IoModel* iomodel, ConstDataHandle iomodel_handle);
void  NodesPartitioning(bool** pmy_nodes,bool* my_elements, bool* my_vertices, bool* my_bordervertices, IoModel* iomodel, ConstDataHandle iomodel_handle,bool continuous);

/*Connectivity*/
void  CreateSingleNodeToElementConnectivity(IoModel* iomodel);
void  CreateNumberNodeToElementConnectivity(IoModel* iomodel);

/*Diverse: */
void  SortDataSets(DataSet** pelements,Nodes** pnodes,Vertices** pvertices, DataSet** ploads, DataSet** pmaterials, DataSet** pconstraints, Parameters** pparameters);
void  UpdateCounters(IoModel* iomodel,Nodes** pnodes,DataSet** ploads, DataSet** pconstraints);

#endif
