/*!\file MinVxx
 */

#include "./MinVxx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void MinVxx( double* pminvx, DataSet* elements,Nodes* nodes, Vertices* vertices, DataSet* loads, DataSet* materials,Parameters* parameters){
	
	int i;
	double minvx;
	double node_minvx;
	bool   process_units=true;
	double element_minvx;

	/*First, configure elements:*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MinVx(&element_minvx,process_units); //go pick up the minimum velocity in the inputs
	
		if(i==0)minvx=element_minvx; //initialize minvx
		else{
			if(element_minvx<minvx)minvx=element_minvx;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		minvx=INFINITY;
	}

	#ifdef _PARALLEL_
	/*Figure out minimum across the cluster: */
	MPI_Reduce (&minvx,&node_minvx,1,MPI_DOUBLE,MPI_MIN,0,MPI_COMM_WORLD );
	MPI_Bcast(&node_minvx,1,MPI_DOUBLE,0,MPI_COMM_WORLD);   
	minvx=node_minvx;
	#endif

	/*Assign output pointers:*/
	*pminvx=minvx;
}
