/*!\file FieldAverageOntoVerticesx
 * \brief: average field throfieldh thickness
 */

#include "./FieldAverageOntoVerticesx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void FieldAverageOntoVerticesx(Vec* pfield, DataSet* elements,Nodes* nodes, Vertices* vertices, DataSet* loads, DataSet* materials, Parameters* parameters){

	/*Intermediary*/
	int i;
	int     numberofvertices,found;
	Vec     connectivity=NULL;
	Vec     fieldsum=NULL;
	double* field_serial=NULL;
	Node*   node=NULL;

	/*Output*/
	Vec field=NULL;

	/*Initialize intermediary*/
	numberofvertices=vertices->NumberOfVertices();
	connectivity=NewVec(numberofvertices);
	fieldsum    =NewVec(numberofvertices);

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Serialize field: */
	VecToMPISerial(&field_serial,*pfield);

	/*Compute summ of connectivity and summ of values: */
	for (i=0;i<nodes->Size();i++){
		node=(Node*)nodes->GetObjectByOffset(i);
		node->FieldAverageOntoVertices(fieldsum,connectivity,field_serial);
	}

	/*Assemble vectors: */
	VecAssemblyBegin(connectivity);
	VecAssemblyEnd(connectivity);
	VecAssemblyBegin(fieldsum);
	VecAssemblyEnd(fieldsum);

	/*Initialize output*/
	field=NewVec(numberofvertices);

	/*Create Field = Fieldsum./connectivity */
	VecPointwiseDivide(field,fieldsum,connectivity);

	/*Assign output pointer*/
	VecFree(pfield);
	*pfield=field;

	/*Free ressources:*/
	xfree((void**)&field_serial);
	VecFree(&connectivity);
	VecFree(&fieldsum);

}
