/*\file CostFunction.c
 *\brief: compute misfit between modeled velocity and observed velocity
 */

#include "./CostFunction.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* loads=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;

	/* output datasets: */
	double J;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&CostFunctionUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*!Call core code: */
	CostFunctionx(&J, elements,nodes,vertices, loads,materials,parameters);

	/*write output : */
	WriteData(COST,J);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void CostFunctionUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [J] = %s(elements,nodes,vertices,loads, materials, parameters);\n",__FUNCT__);
	_printf_("\n");
}
