/*
 * FemModel.h: 
 */

#ifndef _FEMMODEL_H_
#define _FEMMODEL_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "../toolkits/toolkits.h"
class DataSet;
class Parameters;
class NodeSets;
/*}}}*/


class FemModel {

	/*no private members, as we need access to these datasets quite often!:*/

	public:

		int                 nummodels;
		int                 solution_type;
		int*                analysis_type_list; //list of analyses this femmodel is going to carry out
		int                 analysis_counter; //counter into analysis_type_list
		
		DataSet*            elements; //elements (one set for all analyses)
		Nodes*            nodes; //one set of nodes
		DataSet*            vertices; //one set of vertices
		DataSet*            constraints; //one set of constraints. each constraint knows which analysis_type it handles
		DataSet*            loads;  //one set of constraints. each constraint knows which analysis_type it handles
		DataSet*            materials;  //one set of materials, for each element
		Parameters*         parameters; //one set of parameters, independent of the analysis_type
		DataSet*            results; //results that cannot be fit into the elements (such as one time constants, arrays, strings, etc ...)

		Vec                 partition; //one partitioning for all elements
		Vec                 tpartition;
		
		//multiple  sets of matrices/vectors for each analysis_type. m stands for multiple
		Mat*                 m_Rmg; //rigid body motions matrices
		Mat*                 m_Gmn;
		NodeSets**           m_nodesets; //boundary conditions dof sets
		Vec*                 m_yg; //boundary conditions in global g-set
		Vec*                 m_ys; //boundary conditions, in reduced s-set

		//pointers to point to sets of matrices/vectors, for a certain analysis type. activated in SetCurrentAnalysis
		Mat                  Rmg;
		Mat                  Gmn;
		NodeSets*            nodesets;
		Vec                  yg;
		Vec                  ys;

		/*constructors, destructors: */
		FemModel(ConstDataHandle IOMODEL,int solution_type,int* analyses, int nummodels);
		~FemModel();

		/*Methods: */
		void Echo();

		/*Fem: */
		void  SetCurrentAnalysis(int analysis_type);
		void  SetCurrentAnalysisAlias(int base_analysis_type,int real_analysis_type);
		int   GetCurrentAnalysis(void);

};

#endif
