/*!\file MaxAbsVyx
 */

#include "./MaxAbsVyx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void MaxAbsVyx( double* pmaxabsvy, DataSet* elements,Nodes* nodes, DataSet* vertices, DataSet* loads, DataSet* materials,Parameters* parameters){
	
	int i;
	double maxabsvy;
	double node_maxabsvy;
	bool   process_units=true;
	double element_maxabsvy;

	/*First, configure elements:*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxAbsVy(&element_maxabsvy,process_units); //go pick up the minimum velocity in the inputs
	
		if(i==0)maxabsvy=element_maxabsvy; //initialize maxabsvy
		else{
			if(element_maxabsvy>maxabsvy)maxabsvy=element_maxabsvy;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxabsvy=-INFINITY;
	}

	#ifdef _PARALLEL_
	/*Figure out minimum across the cluster: */
	MPI_Reduce (&maxabsvy,&node_maxabsvy,1,MPI_DOUBLE,MPI_MAX,0,MPI_COMM_WORLD );
	MPI_Bcast(&node_maxabsvy,1,MPI_DOUBLE,0,MPI_COMM_WORLD);   
	maxabsvy=node_maxabsvy;
	#endif

	/*Assign output pointers:*/
	*pmaxabsvy=maxabsvy;
}
