/*!\file InputExtrudex
 * \brief: average field throfieldh thickness
 */

#include "./InputExtrudex.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputExtrudex( DataSet* elements,Nodes* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,int enum_type){

	int i;

	/*First, get elements*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Then extrude vertically the new inputs*/
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		if (element->Enum()==PentaEnum){
			Penta* penta=(Penta*)element;
			penta->InputExtrude(enum_type);
		}
	}

}
