/*\file GetSolutionFromInputs.c
 *\brief: recover velocity ug from inputs
 */

#include "./GetSolutionFromInputs.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	Nodes* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	Vec      ug=NULL;

	/* output datasets: elements and loads*/

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&GetSolutionFromInputsUsage);
	
	/*Input datasets: */
	FetchData(&elements,ELEMENTSIN);
	FetchData((DataSet**)&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADSIN);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*!Configure objects:*/
	GetSolutionFromInputsx(&ug,elements, nodes,vertices,loads, materials,parameters);

	/*write output datasets: */
	WriteData(UG,ug);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void GetSolutionFromInputsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [ug] = %s(elements,nodes,vertices,loads, materials,parameters);\n",__FUNCT__);
	_printf_("\n");
}
