/*!\file:  OutputResultsx.cpp
 * \brief: go through our finite elements, and see what results they have stored within. 
 * Then output them into serialized patch arrays, and dump to disk.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./OutputResultsx.h"
#include "../../DataSet/DataSet.h"
#include "../../io/io.h"
#include "../../objects/objects.h"
		
#ifdef _SERIAL_
void OutputResultsx(mxArray** pdataref, DataSet* elements, Nodes* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,DataSet* results){
#else
void OutputResultsx(                    DataSet* elements, Nodes* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,DataSet* results){
#endif

	int         solutiontype;
	

	/*First, configure elements*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Transfer element results into the femmodel->results dataset: */
	ElementResultsToPatch( elements,  nodes,  vertices,  loads, materials, parameters,results);

	#ifdef _PARALLEL_
	/*Results do not include the type of solution being run	. In parallel, we output results to a filename, 
	 *therefore, we need to include the solutiontype into the filename: */
	parameters->FindParam(&solutiontype,SolutionTypeEnum);
	results->AddObject(new StringExternalResult(results->Size()+1,SolutionTypeEnum,EnumAsString(solutiontype),1,0));
	#endif

	/*Write data to matlab structure or filename: */
	#ifdef _SERIAL_
		MatlabWriteResults(pdataref,parameters,results);
	#else
		FileWriteResults(parameters,results);
	#endif
}
