/*!\file InputDepthAveragex
 * \brief: average field throfieldh thickness
 */

#include "./InputDepthAveragex.h"
#include "../InputExtrudex/InputExtrudex.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputDepthAveragex( DataSet* elements,Nodes* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,int enum_type,int average_enum_type){
	
	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*First, get elements*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*First depth-average inputs at base of the glacier*/
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->InputDepthAverageAtBase(enum_type,average_enum_type);
	}


	/*Then extrude vertically the new inputs*/
	InputExtrudex( elements,nodes,vertices,loads,materials,parameters,enum_type);
}
