/*!\file InputAXPYx
 * \brief: Y=Y+aX operation on inputs.
 */

#include "./InputAXPYx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputAXPYx(DataSet* elements,Nodes* nodes,DataSet* vertices,DataSet* loads,DataSet* materials,Parameters* parameters,int YEnum, double scalar, int XEnum){

	/*intermediary:*/
	int      i;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Go through elemnets, and ask to carry out the AXPY operation on inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputAXPY(YEnum, scalar, XEnum);
	}
}
