/*\file NodesDof.c
 *\brief: build degrees of freedom for every grid.
 */

#include "./NodesDof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	DataSet* nodes=NULL;
	Parameters* parameters=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&NodesDofUsage);

	/*Input datasets: */
	FetchData(&nodes,NODESIN);
	FetchParams(&parameters,PARAMETERS);

	/*!Generate internal degree of freedom numbers: */
	NodesDofx(nodes, parameters); 

	/*write output datasets: */
	WriteData(NODES,nodes);

	/*Free ressources: */
	delete nodes;
	delete parameters;
	/*end module: */
	MODULEEND();
}

void NodesDofUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [nodes] = %s(nodes,parameters);\n",__FUNCT__);
	_printf_("\n");
}
