/*\file Qmu.c
 *\brief: launch solution core using Dakota engine.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Qmu.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int         noerr      = 1;

	/*input datasets: */
	mxArray    *femmodel   = NULL;
	Parameters *parameters = NULL;

	/* output datasets: none*/

	#ifndef _HAVE_DAKOTA_ //only works if dakota library has been compiled in.
	ISSMERROR(" Dakota not available! Cannot carry out qmu analysis!");
	#endif

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&QmuUsage);

	/*Input datasets: */
	femmodel=FEMMODEL;

	/*Fetch parameters from femmodel structure: */
	FetchData(&parameters,PARAMETERS);

	/*!Generate internal degree of freedom numbers: */
	Qmux(femmodel,parameters);

	/*end module: */
	MODULEEND();

}

void QmuUsage(void){
	_printf_("\n");
	_printf_("   usage: %s(femmodel,parameters);\n",__FUNCT__);
	_printf_("\n");
}
