/*!\file:  Qmux.h
 * \brief header file for Qmu engine using Dakota
 */ 

#ifndef _QMUX_H
#define _QMUX_H

#include "../../DataSet/DataSet.h"
#include "../../objects/objects.h"

void Qmux(void* femmodel,Parameters* parameters);

/* local prototypes: */
int SpawnCore(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, void* femmodel,int counter);

#ifdef _SERIAL_
void SpawnCoreSerial(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, mxArray* femmodel,int counter);
#else
void SpawnCoreParallel(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, FemModel* femmodel,int counter);
void DakotaResponses(double* responses,char** responses_descriptors,int numresponses,FemModel* femmodel);
void DakotaMPI_Bcast(double** pvariables, char*** pvariables_descriptors,int* pnumvariables, int* pnumresponses);
#endif

#endif  /* _QMUX_H */
