function md=surfaceslopecompute(md);
%SLOPECOMPUTE - compute the surface slope of a model
%
%   Usage:
%      md=surfaceslope(md)
%
	%timing
	t1=clock;

	analysis_types=SlopeAnalysisEnum;
	solution_type=SlopeAnalysisEnum;

	displaystring(md.verbose,'%s',['create finite element model']);
	femmodel=NewFemModel(md,solution_type,analysis_types,1);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		femmodel=surfaceslope_core(femmodel);
	
		displaystring(verbose,'%s',['write results']);
		md.results.surfaceslopecompute=OutputResults(femmodel.elements, femmodel.nodes , femmodel.vertices , femmodel.loads , femmodel.materials, femmodel.parameters, femmodel.results);

	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
