function md=thermal(md)
%THERMAL - thermal solution sequence: steady state and transient
%
%   Usage:
%      md=thermal(md)

	%timing
	t1=clock;
	
	analysis_types=[ThermalAnalysisEnum,MeltingAnalysisEnum];
	solution_type=ThermalAnalysisEnum;

	displaystring(md.verbose,'%s',['reading thermal model data']);
	femmodel=NewFemModel(md,solution_type,analysis_types,2);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		femmodel=thermal_core(femmodel);

		displaystring(verbose,'%s',['write results']);
		md.results.thermal=OutputResults(femmodel.elements, femmodel.nodes , femmodel.vertices , femmodel.loads , femmodel.materials, femmodel.parameters, femmodel.results);
	else
		%launch dakota driver for diagnostic core solution
		Qmu(models,models.t.parameters);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
