function md=prognostic(md)
%PROGNOSITC - prognostic solution sequence.
%
%   Usage:
%      md=prognostic(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	analysis_types=[PrognosticAnalysisEnum];
	solution_type=PrognosticAnalysisEnum;
	
	displaystring(md.verbose,'%s',['reading prognostic model data']);
	femmodel=NewFemModel(md,solution_type,analysis_types,1);

	% figure out number of dof: just for information purposes.
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		femmodel=prognostic_core(femmodel);

		displaystring(verbose,'%s',['write results']);
		md.results.prognostic=OutputResults(femmodel.elements, femmodel.loads, femmodel.nodes, femmodel.vertices, femmodel.materials, femmodel.parameters);
	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
