function md=prognostic2(md)
%PROGNOSITC2 - prognostic2 solution sequence.
%
%   Usage:
%      md=prognostic2(md)

	%timing
	t1=clock;

	analysis_types=[Prognostic2AnalysisEnum];
	solution_type=Prognostic2AnalysisEnum;

	displaystring(md.verbose,'%s',['create finite element model']);
	femmodel=NewFemModel(md,solution_type,analysis_types,1);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		femmodel=prognostic2_core(femmodel);

		displaystring(verbose,'%s',['write results']);
		md.results.prognostic2=OutputResults(femmodel.elements, femmodel.loads, femmodel.nodes, femmodel.vertices, femmodel.materials, femmodel.parameters);
	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
