/*! \file BoolExternalResult.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BOOLEXTERNALRESULT_H_
#define _BOOLEXTERNALRESULT_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class BoolExternalResult: public ExternalResult{

	public:
		int    id;
		int    enum_type;
		bool   value;
		int    step;
		double time;


		/*constructors, destructors: {{{1*/
		BoolExternalResult();
		BoolExternalResult(int id, int enum_type,bool value,int step,double time);
		~BoolExternalResult();

		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();

		void  InputUpdateFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		/*}}}*/
		/*ExternalResult methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  WriteData(FILE* fid);
		char* GetResultName(void);
	    #ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _BOOLEXTERNALRESULT_H */
