/*!\file TriaHook.c
 * \brief: implementation of the TriaHook object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION TriaHook::TriaHook(){{{1*/
TriaHook::TriaHook(){
	numanalyses=UNDEF;
	this->hnodes=NULL;
}
/*}}}*/
/*FUNCTION TriaHook::~TriaHook(){{{1*/
TriaHook::~TriaHook(){
	xfree((void**)&hnodes);
}
/*}}}*/
/*FUNCTION TriaHook::InitHookNodes(int numanalyses){{{1*/
void TriaHook::InitHookNodes(int in_numanalyses){

	ISSMASSERT(in_numanalyses);

	this->numanalyses=in_numanalyses;
	this->hnodes=(Hook*)xmalloc(in_numanalyses*sizeof(Hook));

	for (int i=0;i<in_numanalyses;i++) this->hnodes[i].Init(NULL,0);
}
/*}}}*/
/*FUNCTION TriaHook::SetHookNodes(int* node_ids,int analysis_counter){{{1*/
void TriaHook::SetHookNodes(int* node_ids,int analysis_counter){
	this->hnodes[analysis_counter].Init(node_ids,3);

}
/*}}}*/
/*FUNCTION TriaHook::InitHookMatice(int matice_id){{{1*/
void TriaHook::InitHookMatice(int matice_id){
	this->hmatice.Init(&matice_id,1);
}

/*FUNCTION TriaHook::InitHookMatpar(int matpar_id){{{1*/
void TriaHook::InitHookMatpar(int matpar_id){
	this->hmatpar.Init(&matpar_id,1);
}

